# Charity Notes 12: Soloveitchik 的慈善理论

最后的两课是阅读两位现代的学者拉比。这节课的内容来自于拉比Joseph B. Soloveitchik 博士，而下节课是来自于拉比 Jonathan Sacks 博士。这节课我们将看到拉比索洛维奇如何通过迈蒙尼德作品中的一处矛盾来得出意义。我们在这先提出这一矛盾：这两条法律都出现在 Mishneh Torah中的第十章：给穷人的礼物。

> law 4: 一个人如果以恶劣的态度给穷人钱，那么他摧毁了他的功绩且失去了它。
>
> law 14: 低一级是悲伤地给他。

那是到底迈蒙尼德态度是如何呢，而Rav Soloveitchik 的选择是什么？



## 主观行动或人际参与

Soloveitchik 引用 Maimonides 的 Hilkhot Matenot Aniyim 认为与接受者的内在联系感觉是tzedakah的重要组成部分，并且没有同情和==同情心==的礼物错过了得分。虽然勉强给予tzedakah的最低程度，但它仍然构成了诫命的实现。给予少于适当的金额并且快乐地做到比给予适当数量的勉强更好，但这两种行为都被认为是tzedakah。

Tzedakah的诫命基本上是在平等权利和每个人的同等重要性的基础上加强和促进适当的生活方式。“与你同在”（imakh）暗示“在同一水平，没有区别”;你不要傲慢地对待这个穷人。因此，<u>令人愉悦的面容似乎构成了诫命的一个组成部分</u>，与穷人的这种联系是如此重要，以至于迈蒙尼德认为宁愿要好脸色勉强够的礼物而不是要坏脸色足够的礼物。因此，即使一个人没有可用的手段为穷人提供具体的经济支持，<u>他仍然有义务安慰和鼓励他并提供精神支持</u>，因为这也是tzedakah的一个重要方面。

另一方面，如果一个人勉强做慈善，人们不能说他完全没有履行诫命。这样的前提是错误的，<u>有时候一个穷人愿意放弃他的尊严</u>，只要他能得到他需要的东西给他的家人。一位母亲试图牺牲自己的尊严，心甘情愿地遭受侮辱和尴尬，以便为孩子获得医疗所需的资金。因此，一个勉强屈服的人最好不给予的裁决会背叛对 tzedakah 目标的误解。

此外，Halakhah 还**必须考虑到一个人的心理状态**。有些人天生心痛，缺乏同理心，对另一个人的痛苦也很敏感。他们只能完成一件事：自我强制（self-coercion）。这个棘手问题的解决方案是什么？

1. 首先，**给予的义务是不变的**。捐赠的“如何” - 无论是慷慨还是悲伤，都不能取消潜在的义务；必须向穷人提供经济援助。
2. 其次，即使身体上的帮助不依赖于心理相关性，**后者仍然非常重要**，并构成了tzedakah的基本要素之一。
3. 第三，**禁止使穷人难堪或玷污他的尊严**。这绝对是一种禁令。有必要区分一种无趣的，沮丧的心理状态和一种实际贬低和贬低穷人的姿势。

10:14，迈蒙尼德精心制定了最低程度的诫命。 tzedakah是“悲伤地给予tzedakah。”这个表述是准确的，因为它不是与前面的halakhah中使用的“友好面容”相对立的。因为不是说没有以“带着恶意的面容”的方式，侮辱和损害穷人尊严的方式。

因此，一个人悲伤地履行了“伸开你的手”的诫命，但没有“足以满足他的需要：”他削弱了他对tzedakah诫命的表现，但他没有违反任何禁令。但是当他给出“带着敌意的面容”时，尽管他有所帮助，他的功绩也被取消了。因为他侮辱和侮辱了这个穷人。



whzecomjm
2019年7月4日